/*
Mostra o conteúdo de um arquivo de NUMINT inteiros aleatórios em formato binário.

Antes de executar, criar um arquivo com NUMINT inteiros aleatórios em formato
binário (4 bytes por inteiro). Pode-se fazer isso por exemplo com:

	dd if=/dev/urandom of=randomint.dat bs=SIZE count=1

com SIZE sendo 4 * NUMINT.

Carlos Maziero, DINF/UFPR 2020
*/

#include <stdio.h>
#include <stdlib.h>

// número de valores int no arquivo de dados
#define NUMINT 100000000

int value, num ;
FILE *datafile;

int main (int argc, char *argv[], char *envp[])
{
  // abrir o arquivo de dados
  if (argc < 2)
  {
     printf ("Error: should inform a file name\n") ;
     exit (1) ;
  }
  datafile = fopen (argv[1], "r+") ;
  if ( !datafile)
  {
    perror ("Error fopen") ;
    exit (1) ;
  }

  // ler os dados do arquivo
  num = 0 ;
  while ( !feof (datafile) && (num < NUMINT))
  {
    fread (&value, 1, sizeof (int), datafile) ;
    printf ("%11d\n", value) ;
    num++ ;
  }
  printf ("Read %d values of size %ld bytes each\n", num, sizeof (int)) ;
  fclose (datafile) ;

  exit (0) ;
}

